(ns com.adgoji.cm-floodlight-configurations.core
  (:require
   [com.adgoji.cm-spec.interface :as cm-spec]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.dfareporting Dfareporting Dfareporting$FloodlightConfigurations$List)
   (com.google.api.services.dfareporting.model FloodlightConfiguration)))

(defn get-list
  [^Dfareporting client profile-id {:keys [ids]}]
  (let [profile-id-conformed (spec/check profile-id ::cm-spec/profile-id)
        request              (-> client
                                 (.floodlightConfigurations)
                                 (.list profile-id-conformed))]
    (when (seq ids)
      (.setIds ^Dfareporting$FloodlightConfigurations$List request
               (spec/check ids ::cm-spec/ids)))
    (-> (sdk-client-utils/execute-and-convert request)
        :floodlight-configurations
        (spec/check ::cm-spec/floodlight-configurations))))

(defn get-by-id
  [^Dfareporting client profile-id configuration-id]
  (-> client
      (.floodlightConfigurations)
      (.get (spec/check profile-id ::cm-spec/profile-id)
            (spec/check configuration-id ::cm-spec/floodlight-configuration-id))
      (sdk-client-utils/execute-and-convert)
      (spec/check ::cm-spec/floodlight-configuration)))

(defn patch
  [^Dfareporting client profile-id configuration-id content]
  (let [content-conformed (spec/check content ::cm-spec/floodlight-configuration)
        content-request   (java-utils/clj->java FloodlightConfiguration
                                                content-conformed)]
    (-> client
        (.floodlightConfigurations)
        (.patch (spec/check profile-id ::cm-spec/profile-id)
                (spec/check configuration-id ::cm-spec/floodlight-configuration-id)
                content-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::cm-spec/floodlight-configuration))))

(defn put
  [^Dfareporting client profile-id configuration]
  (let [content-conformed (spec/check configuration ::cm-spec/floodlight-configuration)
        content-request   (java-utils/clj->java FloodlightConfiguration
                                                content-conformed)]
    (-> client
        (.floodlightConfigurations)
        (.update (spec/check profile-id ::cm-spec/profile-id)
                 content-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::cm-spec/floodlight-configuration))))
