(ns com.adgoji.cm-spec.cm.report.cross-dimension-reach-criteria
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.cm-spec.cm.date-range :as date-range]
   [com.adgoji.cm-spec.cm.dimension-value :as dimension-value]
   [com.adgoji.cm-spec.cm.sorted-dimension :as sorted-dimension]))

(s/def ::date-range ::date-range/spec)
(s/def ::dimension
  #{"ADVERTISER"
    "CAMPAIGN"
    "SITE_BY_ADVERTISER"
    "SITE_BY_CAMPAIGN"})
(s/def ::pivoted boolean?)
(s/def ::dimension-filters
  (s/coll-of ::dimension-value/spec :into [] :distinct true))
(s/def ::breakdown
  (s/coll-of ::sorted-dimension/spec :into [] :distinct true))
(s/def ::metric-names
  (s/coll-of string? :into [] :distinct true))
(s/def ::overlap-mertic-names
  (s/coll-of string? :into [] :distinct true))
(s/def ::spec
  (s/keys :opt-un [::date-range
                   ::dimension
                   ::pivoted
                   ::dimension-filters
                   ::breakdown
                   ::metric-names
                   ::overlap-mertic-names]))
