(ns com.adgoji.cm-spec.cm.file
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.cm-spec.cm.report :as report]
   [com.adgoji.cm-spec.cm.date-range :as date-range]
   [com.adgoji.cm-spec.cm.file.urls :as file.urls]))

(s/def ::id spec/strict-long?)
(s/def ::report-id ::report/id)
(s/def ::etag string?)
(s/def ::status
  #{"PROCESSING"
    "REPORT_AVAILABLE"
    "FAILED"
    "CANCELLED"
    "QUEUED"})
(s/def ::file-name string?)
(s/def ::kind string?)
(s/def ::date-range ::date-range/spec)
(s/def ::format #{"CSV" "EXCEL"})
(s/def ::last-modified-time integer?)
(s/def ::urls ::file.urls/spec)
(s/def ::spec
  (s/keys :req-un [::id
                   ::report-id
                   ::status
                   ::kind
                   ::date-range]
          :opt-un [::format
                   ::etag
                   ::file-name
                   ::last-modified-time
                   ::urls]))
