(ns com.adgoji.cm-spec.interface
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.cm-spec.cm :as cm]))

;;; Client

(s/def ::client ::cm/client)

;;; IDs

(s/def ::profile-id ::cm/profile-id)
(s/def ::advertiser-id ::cm/advertiser-id)
(s/def ::floodlight-configuration-id ::cm/floodlight-configuration-id)
(s/def ::floodlight-activity-group-id ::cm/floodlight-activity-group-id)
(s/def ::floodlight-activity-id ::cm/floodlight-activity-id)

;;; Query parameters

(s/def ::max-results ::cm/max-results)
(s/def ::subaccount-id ::cm/subaccount-id)
(s/def ::advertiser-status ::cm/advertiser-status)
(s/def ::advertiser-group-ids ::cm/advertiser-group-ids)
(s/def ::floodlight-configuration-ids ::cm/floodlight-configuration-ids)
(s/def ::include-advertisers-without-groups-only ::cm/include-advertisers-without-groups-only)
(s/def ::only-parent ::cm/only-parent)
(s/def ::ids ::cm/ids)
(s/def ::search-string ::cm/search-string)
(s/def ::sort-field ::cm/sort-field)
(s/def ::sort-order ::cm/sort-order)
(s/def ::floodlight-activity-group-ids ::cm/floodlight-activity-group-ids)
(s/def ::floodlight-activity-group-type ::cm/floodlight-activity-group-type)
(s/def ::floodlight-activity-group-tag-string ::cm/floodlight-activity-group-tag-string)
(s/def ::floodlight-activity-group-name ::cm/floodlight-activity-group-name)
(s/def ::floodlight-activity-tag-string ::cm/floodlight-activity-tag-string)

;;; Entities

(s/def ::advertiser ::cm/advertiser)
(s/def ::advertiser-update ::cm/advertiser-update)
(s/def ::advertisers ::cm/advertisers)

(s/def ::floodlight-configuration ::cm/floodlight-configuration)
(s/def ::floodlight-configurations ::cm/floodlight-configurations)

(s/def ::floodlight-activity-group ::cm/floodlight-activity-group)
(s/def ::floodlight-activity-group-update ::cm/floodlight-activity-group-update)
(s/def ::floodlight-activity-groups ::cm/floodlight-activity-groups)

(s/def ::floodlight-activity ::cm/floodlight-activity)
(s/def ::floodlight-activity-update ::cm/floodlight-activity-update)
(s/def ::floodlight-activities ::cm/floodlight-activities)

(s/def ::floodlight-activities-generate-tag-response ::cm/floodlight-activities-generate-tag-response)
