(ns com.adgoji.cm-spec.cm
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.cm-spec.cm.advertiser :as advertiser]
   [com.adgoji.cm-spec.cm.query-params :as query-params]
   [com.adgoji.cm-spec.cm.floodlight-configuration :as floodlight-configuration]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.cm-spec.cm.floodlight-activity-group :as floodlight-activity-group]
   [com.adgoji.cm-spec.cm.floodlight-activity :as floodlight-activity]
   [com.adgoji.cm-spec.cm.floodlight-activities-generate-tag-response :as floodlight-activities-generate-tag-response]))

(s/def ::client
  (partial instance? com.google.api.services.dfareporting.Dfareporting))

(s/def ::profile-id spec/strict-long?)
(s/def ::advertiser-id ::advertiser/id)
(s/def ::floodlight-configuration-id ::floodlight-configuration/id)
(s/def ::floodlight-activity-group-id ::floodlight-activity-group/id)
(s/def ::floodlight-activity-id ::floodlight-activity/id)

(s/def ::max-results ::query-params/max-results)
(s/def ::subaccount-id ::query-params/subaccount-id)
(s/def ::advertiser-status ::advertiser/status)
(s/def ::advertiser-group-ids ::query-params/advertiser-group-ids)
(s/def ::floodlight-configuration-ids
  (s/coll-of ::floodlight-configuration/id :distinct true :into []))
(s/def ::include-advertisers-without-groups-only ::query-params/include-advertisers-without-groups-only)
(s/def ::only-parent ::query-params/only-parent)
(s/def ::ids ::query-params/ids)
(s/def ::search-string ::query-params/search-string)
(s/def ::sort-field ::query-params/sort-field)
(s/def ::sort-order ::query-params/sort-order)
(s/def ::floodlight-activity-group-ids
  (s/coll-of ::floodlight-activity-group/id :distinct true :into []))
(s/def ::floodlight-activity-group-type ::floodlight-activity-group/type)
(s/def ::floodlight-activity-group-tag-string ::floodlight-activity-group/tag-string)
(s/def ::floodlight-activity-group-name ::floodlight-activity-group/name)
(s/def ::floodlight-activity-tag-string ::floodlight-activity/tag-string)

(s/def ::advertiser ::advertiser/spec)
(s/def ::advertiser-update ::advertiser/spec-update)
(s/def ::advertisers
  (s/coll-of ::advertiser :distinct true :into []))
(s/def ::floodlight-configuration ::floodlight-configuration/spec)
(s/def ::floodlight-configurations
  (s/coll-of ::floodlight-configuration :distinct true :into []))
(s/def ::floodlight-activity-group ::floodlight-activity-group/spec)
(s/def ::floodlight-activity-group-update ::floodlight-activity-group/spec-update)
(s/def ::floodlight-activity-groups
  (s/coll-of ::floodlight-activity-group/spec :distinct true :into []))
(s/def ::floodlight-activity ::floodlight-activity/spec)
(s/def ::floodlight-activity-update ::floodlight-activity/spec-update)
(s/def ::floodlight-activities
  (s/coll-of ::floodlight-activity/spec :distinct true :into []))
(s/def ::floodlight-activities-generate-tag-response ::floodlight-activities-generate-tag-response/spec)
