(ns com.adgoji.ad-manager-companies.core
  (:require
   [com.adgoji.ad-manager-client.interface :as ad-manager-client]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.soap-client-utils.interface :as soap-client-utils])
  (:import
   (com.google.api.ads.admanager.axis.utils.v202502 StatementBuilder)
   (com.google.api.ads.admanager.axis.v202502 Company CompanyPage CompanyServiceInterface)))

(defn create
  [client companies]
  (let [service (ad-manager-client/service client :company)
        body    (->> companies
                     (sequence (map (partial java-utils/clj->java Company)))
                     (into-array Company))]
    (soap-client-utils/execute-and-convert CompanyServiceInterface/.createCompanies
                                           service
                                           body)))

(defn- fetch-companies-page
  [^CompanyServiceInterface service ^StatementBuilder statement-builder offset]
  (.increaseOffsetBy statement-builder (int offset))
  (soap-client-utils/execute-and-convert (comp CompanyPage/.getResults
                                               CompanyServiceInterface/.getCompaniesByStatement)
                                         service
                                         (.toStatement statement-builder)))

(defn all
  [client statement {:keys [limit]}]
  (let [service   (ad-manager-client/service client :company)
        page-size StatementBuilder/SUGGESTED_PAGE_LIMIT
        statement (-> (soap-client-utils/statement-builder statement)
                      (.limit page-size))]
    (soap-client-utils/execute-and-convert-paginated
     (partial fetch-companies-page service statement)
     page-size
     {:limit limit})))
