(ns com.adgoji.ad-manager-api.orders
  (:require
   [com.adgoji.ad-manager-orders.interface :as ad-manager-orders]))

(defn create
  "Create multiple orders."
  [client orders]
  (ad-manager-orders/create client orders))

(defn patch
  "Update specified orders."
  [client orders]
  (ad-manager-orders/patch client orders))

(defn all
  "Return list of Orders that satisfy provided `statement`."
  [client statement params]
  (ad-manager-orders/all client statement params))

(defn perform-action
  "Performs action on Order object with provided `order-id`."
  [client order-id action]
  (ad-manager-orders/perform-action client order-id action))
