(ns com.adgoji.ad-manager-line-item-creative-associations.core
  (:require
   [com.adgoji.ad-manager-client.interface :as ad-manager-client]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.soap-client-utils.interface :as soap-client-utils])
  (:import
   (com.google.api.ads.admanager.axis.utils.v202502 StatementBuilder)
   (com.google.api.ads.admanager.axis.v202502 ActivateLineItemCreativeAssociations DeactivateLineItemCreativeAssociations DeleteLineItemCreativeAssociations LineItemCreativeAssociation LineItemCreativeAssociationPage LineItemCreativeAssociationServiceInterface)))

(defn create
  [client associations]
  (let [service (ad-manager-client/service client :line-item-creative-association)
        body    (->> associations
                     (sequence (map (partial java-utils/clj->java LineItemCreativeAssociation)))
                     (into-array LineItemCreativeAssociation))]
    (soap-client-utils/execute-and-convert
     LineItemCreativeAssociationServiceInterface/.createLineItemCreativeAssociations
     service
     body)))

(defn patch
  [client associations]
  (let [service (ad-manager-client/service client :line-item-creative-association)
        body    (->> associations
                     (sequence (map (partial java-utils/clj->java LineItemCreativeAssociation)))
                     (into-array LineItemCreativeAssociation))]
    (soap-client-utils/execute-and-convert
     LineItemCreativeAssociationServiceInterface/.updateLineItemCreativeAssociations
     service
     body)))

(defn- fetch-associations-page
  [^LineItemCreativeAssociationServiceInterface service
   ^StatementBuilder statement-builder
   offset]
  (.increaseOffsetBy statement-builder (int offset))
  (soap-client-utils/execute-and-convert
   (comp LineItemCreativeAssociationPage/.getResults
         LineItemCreativeAssociationServiceInterface/.getLineItemCreativeAssociationsByStatement)
   service
   (.toStatement statement-builder)))

(defn all
  [client statement {:keys [limit]}]
  (let [service   (ad-manager-client/service client :line-item-creative-association)
        page-size StatementBuilder/SUGGESTED_PAGE_LIMIT
        statement (-> (soap-client-utils/statement-builder statement)
                      (.limit page-size))]
    (soap-client-utils/execute-and-convert-paginated
     (partial fetch-associations-page service statement)
     page-size
     {:limit limit})))

(def ^:private association-action
  {:activate-line-item-creative-associations   (ActivateLineItemCreativeAssociations/new)
   :deactivate-line-item-creative-associations (DeactivateLineItemCreativeAssociations/new)
   :delete-line-item-creative-associations     (DeleteLineItemCreativeAssociations/new)})

(defn perform-action
  [client statement action]
  (let [service   (ad-manager-client/service client :line-item-creative-association)
        statement (-> (soap-client-utils/statement-builder statement)
                      (.toStatement))]
    (soap-client-utils/execute-and-convert
     LineItemCreativeAssociationServiceInterface/.performLineItemCreativeAssociationAction
     service
     (association-action action)
     statement)))
