(ns com.adgoji.ad-manager-api.networks
  (:require
   [com.adgoji.ad-manager-networks.interface :as ad-manager-networks]))

(defn make-test
  "Creates a new blank network for testing purposes using the current
  login.

  Each login (i.e. email address) can only have one test network.
  Data from any of your existing networks will not be transferred to
  the new test network.  Once the test network is created, the test
  network can be used in the API by supplying the `network-code` to
  the new API client function or by logging into the Ad Manager UI.

  Test networks are limited in the following ways:

  - Test networks cannot serve ads.

  - Because test networks cannot serve ads, reports will always come
    back without data.

  - Since forecasting requires serving history, forecast service
    results will be faked.

  - Test networks are, by default, Ad Manager networks and don't have
    any features from Ad Manager 360.

  - Test networks are limited to 10,000 objects per entity type."
  [client]
  (ad-manager-networks/make-test client))

(defn patch
  "Update a single `network`."
  [client network]
  (ad-manager-networks/patch client network))

(defn current
  "Returns the current network for which requests are being made."
  [client]
  (ad-manager-networks/current client))

(defn all
  "Returns the list of Network objects to which the current login has
  access."
  [client]
  (ad-manager-networks/all client))
