(ns com.adgoji.ad-manager-client.core
  (:import
   (com.google.api.ads.admanager.axis.factory AdManagerServices)
   (com.google.api.ads.admanager.axis.v202502 CompanyServiceInterface CreativeServiceInterface ForecastServiceInterface InventoryServiceInterface LineItemCreativeAssociationServiceInterface LineItemServiceInterface NetworkServiceInterface OrderServiceInterface PublisherQueryLanguageServiceInterface ReportServiceInterface UserServiceInterface)
   (com.google.api.ads.admanager.lib.client AdManagerSession$Builder)
   (com.google.api.client.auth.oauth2 Credential)))

(defn new-session
  [^Credential credential ^String application-name ^String network-code]
  (-> (AdManagerSession$Builder.)
      (.withOAuth2Credential credential)
      (.withApplicationName application-name)
      (.withNetworkCode network-code)
      (.buildImmutable)))

(defn new-services-factory
  ^AdManagerServices
  []
  (AdManagerServices.))

(def services
  {:network                        NetworkServiceInterface
   :company                        CompanyServiceInterface
   :user                           UserServiceInterface
   :order                          OrderServiceInterface
   :inventory                      InventoryServiceInterface
   :line-item                      LineItemServiceInterface
   :creative                       CreativeServiceInterface
   :line-item-creative-association LineItemCreativeAssociationServiceInterface
   :forecast                       ForecastServiceInterface
   :pql                            PublisherQueryLanguageServiceInterface
   :report                         ReportServiceInterface})
