(ns com.adgoji.ad-manager-api.forecast
  (:require
   [com.adgoji.ad-manager-forecast.interface :as ad-manager-forecast]))

(defn delivery
  "Gets the delivery forecast for a list of `prospective-line-item`
  objects in a single delivery simulation with line items potentially
  contending with each other.

  A delivery forecast reports the number of units that will be
  delivered to each line item given the line item goals and
  contentions from other line items."
  [client prospective-line-items opts]
  (ad-manager-forecast/delivery client prospective-line-items opts))

(defn delivery-by-ids
  "Gets the delivery forecast for a list of existing LineItem objects in
  a single delivery simulation.

  A delivery forecast reports the number of units that will be
  delivered to each line item given the line item goals and
  contentions from other line items."
  [client line-item-ids opts]
  (ad-manager-forecast/delivery-by-ids client line-item-ids opts))

(defn availability
  "Gets the availability forecast for a `prospective-line-item`.

  An availability forecast reports the maximum number of available
  units that the line item can book, and the total number of units
  matching the line item's targeting."
  [client prospective-line-item opts]
  (ad-manager-forecast/availability client prospective-line-item opts))

(defn availability-by-id
  "Gets an AvailabilityForecast for an existing LineItem object.

  An availability forecast reports the maximum number of available
  units that the line item can be booked with, and also the total
  number of units matching the line item's targeting.

  Only line items having type SPONSORSHIP or STANDARD are valid. Other
  types will throw a LINE_ITEM_TYPE_NOT_ALLOWED error."
  [client line-item-id opts]
  (ad-manager-forecast/availability-by-id client line-item-id opts))
