(ns com.adgoji.ad-manager-api.client
  (:require
   [com.adgoji.ad-manager-client.interface :as ad-manager-client]
   [com.adgoji.google-credential.interface :as google-credential])
  (:import
   (com.google.api.ads.admanager.lib.client AdManagerSession)
   (com.google.api.ads.common.lib.auth OfflineCredentials$Api)
   (com.google.api.client.auth.oauth2 Credential)))

(defn google-credential
  [opts]
  (let [api   OfflineCredentials$Api/AD_MANAGER
        scope (.getScope api)]
    (google-credential/new (assoc opts :scopes [scope]))))

(defn new
  ^AdManagerSession
  [^Credential credential ^String application-name ^String network-code]
  (ad-manager-client/new credential application-name network-code))
