(ns com.adgoji.ad-manager-api.users
  (:require
   [com.adgoji.ad-manager-users.interface :as ad-manager-users]))

(defn all-roles
  "Returns the Role objects that are defined for the users of the
  network."
  [client]
  (ad-manager-users/all-roles client))

(defn create
  "Create multiple users."
  [client users]
  (ad-manager-users/create client users))

(defn patch
  "Update multiple users."
  [client users]
  (ad-manager-users/patch client users))

(defn current
  "Returns the current User."
  [client]
  (ad-manager-users/current client))

(defn all
  "Returns list of Users that satisfy provided `statement`."
  [client statement params]
  (ad-manager-users/all client statement params))

(defn perform-action
  "Performs action on User object with provided `user-id`."
  [client user-id action]
  (ad-manager-users/perform-action client user-id action))
