(ns com.adgoji.ad-manager-api.ad-units
  (:require
   [com.adgoji.ad-manager-ad-units.interface :as ad-manager-ad-units]))

(defn create
  "Create multiple ad units."
  [client ad-units]
  (ad-manager-ad-units/create client ad-units))

(defn patch
  "Update multiple ad units."
  [client ad-units]
  (ad-manager-ad-units/patch client ad-units))

(defn all-sizes
  "Returns a set of all relevant AdUnitSize objects."
  [client]
  (ad-manager-ad-units/all-sizes client))

(defn all
  "Return list of ad units that satisfy provided `statement`."
  [client statement params]
  (ad-manager-ad-units/all client statement params))

(defn perform-action
  "Performs action on ad unit object with provided `ad-unit-id`."
  [client ad-unit-id action]
  (ad-manager-ad-units/perform-action client ad-unit-id action))
