(ns com.adgoji.ad-manager-networks.core
  (:require
   [com.adgoji.ad-manager-client.interface :as ad-manager-client]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.soap-client-utils.interface :as soap-client-utils])
  (:import
   (com.google.api.ads.admanager.axis.v202502 Network NetworkServiceInterface)))

(defn make-test
  [client]
  (let [service (ad-manager-client/service client :network)]
    (soap-client-utils/execute-and-convert NetworkServiceInterface/.makeTestNetwork
                                           service)))

(defn patch
  [client network]
  (let [service (ad-manager-client/service client :network)
        body    (java-utils/clj->java Network network)]
    (soap-client-utils/execute-and-convert NetworkServiceInterface/.updateNetwork
                                           service
                                           body)))

(defn current
  [client]
  (let [service (ad-manager-client/service client :network)]
    (soap-client-utils/execute-and-convert NetworkServiceInterface/.getCurrentNetwork
                                           service)))

(defn all
  [client]
  (let [service (ad-manager-client/service client :network)]
    (soap-client-utils/execute-and-convert NetworkServiceInterface/.getAllNetworks
                                           service)))
