(ns com.adgoji.ad-manager-forecast.core
  (:require
   [com.adgoji.ad-manager-client.interface :as ad-manager-client]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.soap-client-utils.interface :as soap-client-utils])
  (:import
   (com.google.api.ads.admanager.axis.v202502 AvailabilityForecastOptions DeliveryForecastOptions ForecastServiceInterface ProspectiveLineItem)))

(defn delivery
  [client prospective-line-items opts]
  (let [service       (ad-manager-client/service client :forecast)
        body          (->> prospective-line-items
                           (sequence (map (partial java-utils/clj->java ProspectiveLineItem)))
                           (into-array ProspectiveLineItem))
        forecast-opts (java-utils/clj->java DeliveryForecastOptions opts)]
    (soap-client-utils/execute-and-convert
     ForecastServiceInterface/.getDeliveryForecast
     service
     body
     forecast-opts)))

(defn delivery-by-ids
  [client line-item-ids opts]
  (let [service       (ad-manager-client/service client :forecast)
        body          (long-array line-item-ids)
        forecast-opts (java-utils/clj->java DeliveryForecastOptions opts)]
    (soap-client-utils/execute-and-convert
     ForecastServiceInterface/.getDeliveryForecastByIds
     service
     body
     forecast-opts)))

(defn availability
  [client prospective-line-item opts]
  (let [service       (ad-manager-client/service client :forecast)
        body          (java-utils/clj->java ProspectiveLineItem prospective-line-item)
        forecast-opts (java-utils/clj->java AvailabilityForecastOptions opts)]
    (soap-client-utils/execute-and-convert
     ForecastServiceInterface/.getAvailabilityForecast
     service
     body
     forecast-opts)))

(defn availability-by-id
  [client line-item-id opts]
  (let [service       (ad-manager-client/service client :forecast)
        forecast-opts (java-utils/clj->java AvailabilityForecastOptions opts)]
    (soap-client-utils/execute-and-convert
     ForecastServiceInterface/.getAvailabilityForecastById
     service
     (long line-item-id)
     forecast-opts)))
