(ns com.adgoji.ad-manager-api.reports
  (:require
   [com.adgoji.ad-manager-reports.interface :as ad-manager-reports]))

(defn run-job
  "Initiates the execution of a report query on the server.

  See the detailed description of the `job` parameter here:
  [[https://developers.google.com/ad-manager/api/reference/v202505/ReportService.ReportJob]]."
  [client job]
  (ad-manager-reports/run-job client job))

(defn get-job-status
  "Returns the status of the report job with the specified `job-id`.

  Status can be one of the following values:
  - COMPLETED
  - IN_PROGRESS
  - FAILED"
  [client job-id]
  (ad-manager-reports/get-job-status client job-id))

(defn get-download-url
  "Returns the URL at which the report file can be downloaded.

  The report will be generated as a gzip archive, containing the
  report file itself.

  `export-format` can be one of the following values:
  - TSV
  - TSV_EXCEL
  - CSV_DUMP
  - XML
  - XLSX"
  [client job-id export-format]
  (ad-manager-reports/get-download-url client job-id export-format))

(defn get-download-url-with-options
  "Returns the URL at which the report file can be downloaded, and allows
  for customization of the downloaded report."
  [client job-id opts]
  (ad-manager-reports/get-download-url-with-options client job-id opts))

(defn get-saved-queries
  "Return list of saved queries either created by or shared with the
  current user."
  [client statement params]
  (ad-manager-reports/get-saved-queries client statement params))
