(ns com.adgoji.soap-client-utils.interface
  (:require
   [com.adgoji.soap-client-utils.core :as soap-client-utils.core])
  (:import
   (com.google.api.ads.admanager.axis.utils.v202502 StatementBuilder)))

(defn statement-builder
  "Return an instance of [[StatementBuilder]] class, produced from
  provided `params`.

  Params should be a map that represents a valid PQL query.  Supported
  keys are:
  - `:select` (a vector of columns as keywords)
  - `:from` (a table name as a keyword)
  - `:where` (a vector of triples, first item is an operation, second
    is a variable name, third is a variable value)
  - `:order-by` (a vector of a column as a keyword and optional
    direction second element.  Supported directions are `:asc` and
    `:desc`)"
  ^StatementBuilder
  [params]
  (soap-client-utils.core/statement-builder params))

(defn execute-and-convert
  "Call `request-method` with provided `args` and convert response to
  Clojure data.

  Catch SOAP API exception and throw proper Clojure `ex-info` with
  exception data."
  [request-method & args]
  (soap-client-utils.core/execute-and-convert request-method args))

(defn execute-and-convert-paginated
  "Execute SOAP API request and convert response to Clojure data.

  If `fetch-page-fn` returns non-nil, fetch the next page by calling
  it again with `page-size` passed as a last argument.  Returns only
  `limit` number of entries."
  [fetch-page-fn page-size params]
  (soap-client-utils.core/execute-and-convert-paginated fetch-page-fn
                                                        page-size
                                                        params))

(def date-time soap-client-utils.core/date-time)
