(ns com.adgoji.ad-manager-client.interface
  (:require
   [com.adgoji.ad-manager-client.core :as ad-manager-client.core])
  (:import
   (com.google.api.client.auth.oauth2 Credential)))

(defprotocol AdManagerClient
  "Client abstraction for Ad Manager SOAP API."
  (session [this])
  (services-factory [this])
  (service [this service-key]
    "Return a service for current session by `service-key` using services
  factory."))

(defn new
  [^Credential credential ^String application-name ^String network-code]
  (let [client-session (ad-manager-client.core/new-session credential application-name network-code)
        client-factory (ad-manager-client.core/new-services-factory)]
    (reify
      AdManagerClient
      (session [_this]
        client-session)

      (services-factory [_this]
        client-factory)

      (service [_this service-key]
        (if-let [service-class (get ad-manager-client.core/services service-key)]
          (.get client-factory client-session service-class)
          (throw (ex-info "Service is not supported"
                          {:service service-key})))))))
