(ns aclaimant.server.content-type
  (:require
    [aclaimant.server.core.request :as request]
    [camel-snake-kebab.core :as csk]
    [camel-snake-kebab.extras :as csk-extras]
    [cheshire.core :as json]))

(defn- ->json-keys [body]
  (-> body
      request/jsonify-keys
      json/generate-string))

(defn- ->edn [body]
  (->> body
       (csk-extras/transform-keys csk/->kebab-case-keyword)
       pr-str))

(defn transform-and-content-type [accept]
  (condp re-find accept
    #"^application/edn" :json
    #"^application/json" :edn
    nil))

(def content-types
  {:json [->edn "application/edn"]
   :edn [->json-keys "application/json"]})

(defn wrap-content-type-response
  "Responds with a client-specified content-type"
  [handler & [default-accept]]
  (fn [request]
    (let [{:keys [headers] :as response} (handler request)
          default-accept (or default-accept :json)
          accept (get-in request [:headers "accept"])
          [transformer content-type] (content-types
                                       (or (transform-and-content-type accept) default-accept))]
      (-> response
          (update :body #(transformer (if (string? %) (json/parse-string %) %)))
          (update :headers assoc "Content-Type" content-type)))))
