(ns aclaimant.server.core.uptime
  (:require
    [clj-time.core :as time]))

(defonce ^:private start-time (atom (time/now)))

(defn uptime
  "How long in seconds by default has the system been up.
  Accept a clj-time fn to translate the difference."
  ([]
   (uptime time/in-seconds))
  ([formatter]
   (let [difference (time/interval @start-time
                                   (time/now))]
     (formatter difference))))

(def uptime-mins
  "Helper to give uptime in minutes"
  (partial uptime time/in-minutes))

