(ns aclaimant.server.core.maps
  (:require
    [clojure.walk :as walk]))

(defn ^:private filter-values [func m]
  (into (empty m)
        (filter (fn [[k v]] (func v))
                m)))

(defn ^:private filter-values-rec [func m]
  (walk/postwalk
    (fn [m2]
      (if (map? m2)
        (into (empty m2) (filter (comp func second) m2))
        m2))
    m))


(defn without-nils [obj]
  (filter-values-rec (complement nil?) obj))

(defn deep-merge
  "Recursively merges maps. If keys are not maps, the last value wins."
  [& vals]
  (if (every? map? vals)
    (apply merge-with deep-merge vals)
    (last vals)))

