(ns aclaimant.server.core.json-response
  (:require
    [aclaimant.server.core.utils.uptime :as uptime]
    [cheshire.core :as json]
    [clj-time.core :as time]
    [trptcolin.versioneer.core :as version]))

(defn build
  "with one argument, build a 200 json response from map,
   with two arguments, build a status json respond from map"
  ([obj]
   (build 200 obj))
  ([status obj]
   {:status status
    :headers {"Content-Type" "application/json"}
    :body (json/generate-string obj)}))

(defn build-status
  "Build a status response, accepts a map to be merged into the default"
  [app-group app-artifact & additional]
  (let [m (apply array-map additional)]
    (build
      (merge {:uptime-seconds (uptime/uptime)
              :current-time (time/now)
              :app-name app-artifact
              :app-version (version/get-version app-group app-artifact)}
             m))))
