(ns coconut.v1.platform
  (:require
    [goog.string :as gstring]
    [goog.string.format]
    [clojure.string :as cs]
    ))

(def defined-tests (atom {}))

(defn register-component
  ([component containing-namespace options]
   (swap! defined-tests
          update-in
          [(::component-version options) containing-namespace]
          concat
          (vector component))))

(defn registered-components
  ([options]
   (flatten (vals (get @defined-tests
                       (::component-version options))))))

(defn format
  ([f & strings]
   (apply gstring/format f strings)))

(defn current-time-millis
  ([]
   (.now js/Date)))

(defmulti exception-class-name
  (fn [obj]
    (type obj)))

(defmethod exception-class-name
  js/Error
  ([e]
   (.-name (.-constructor e))))

(defmethod exception-class-name
  js/Function
  ([exception-class]
   (.-name (.-constructor (.-prototype exception-class)))))

(defn exception-message
  ([e]
   (.-message e)))

(defn exception-stack-trace
  ([e]
   (into (vector)
         (map cs/trim)
         (cs/split-lines (.-stack e)))))

(defn exception
  ([message]
   (js/Error. message)))

(defn exception?
  ([value]
   (instance? js/Error value)))

(def illegal-argument-exception-type
  js/Error)

(def throwable-type
  js/Object)

(defn illegal-argument-exception
  ([message]
   (js/Error. message)))

(defn subpath?
  ([parent child]
   (.endsWith parent child)))

(def ^{:const true} integer-max-value
  (.-MAX_SAFE_INTEGER js/Number))

(defn generate-uuid
  ([]
   (str (random-uuid))))

(def language-specific-stack-trace-element-regex
  #"^(cljs|coconut)\..*")

(defn set-immediate
  ([f]
   (js/setTimeout f 0)))

(def max-int
  js/Number.MAX_SAFE_INTEGER)
