(ns coconut.v1.platform
  (:refer-clojure :exclude [format]) (:require
    [clojure.string :as cs]
    ))

(defn register-component
  ([component containing-namespace options]
   (intern (the-ns (symbol containing-namespace))
           (with-meta (gensym)
                      #::{:registered-component? true
                          :component-version (::component-version options)})
           component)))

(defn registered-components
  ([options]
   (into (vector)
         (comp (map ns-publics)
               (mapcat vals)
               (filter (comp ::registered-component?
                             meta))
               (filter (comp (partial = (::component-version options))
                             ::component-version
                             meta))
               (map var-get))
         (all-ns))))

(defn format
  ([f & strings]
   (apply clojure.core/format f strings)))

(defn current-time-millis
  ([]
   (System/currentTimeMillis)))

(defmulti exception-class-name
  (fn [obj]
    (type obj)))

(defmethod exception-class-name
  java.lang.Class
  ([c]
   (.getName c)))

(defmethod exception-class-name
  java.lang.Throwable
  ([o]
   (exception-class-name (.getClass o))))

(defn exception-message
  ([e]
   (.getMessage e)))

(defn exception-stack-trace
  ([e]
   (into (vector)
         (map str)
         (.getStackTrace e))))

(defn exception
  ([message]
   (Exception. message)))

(defn exception?
  ([value]
   (instance? Throwable value)))

(def illegal-argument-exception-type
  IllegalArgumentException)

(def throwable-type
  java.lang.Throwable)

(defn illegal-argument-exception
  ([message]
   (IllegalArgumentException. message)))

(defn subpath?
  ([parent child]
   (.endsWith (java.nio.file.Paths/get parent (make-array String 0))
              (java.nio.file.Paths/get child (make-array String 0)))))

(def ^{:const true} integer-max-value
  Integer/MAX_VALUE)

(defn generate-uuid
  ([]
   (str (java.util.UUID/randomUUID))))

(def language-specific-stack-trace-element-regex
  #"^(sun|clojure|java)\..*")

(defn set-immediate
  ([f]
   (future (f))))

(def max-int
  Integer/MAX_VALUE)
