(ns coconut.v1.util
  #?(:cljs (:require-macros [cljs.core.async.macros :as async]))
  (:require
    [clojure.core.async :as async :refer [<! >!]]
    ))

(defn channel-consuming
  "Given a function, returns a new function which is invoked for
  each value taken from the channel."
  ([f]
   (fn [channel]
     (async/go
       (loop []
         (when-let [e (<! channel)]
           (f e)
           (recur)))))))
