(ns coconut.v1.rendering-test
  (:require
    [coconut.v1.core :as c]
    [coconut.v1.rendering :as rendering]
    ))

(c/describe `rendering/word-wrap
  (c/for [t [{:description "returns empty collection for empty string"
              :input ""
              :output []}
             {:description "returns a single line for a single word less than the limit"
              :input "xxx"
              :output ["xxx"]}
             {:description "returns a single line for a single word which is longer than the limit"
              :input "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"
              :output ["xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"]}
             {:description "returns a single line for multiple words which are less than the limit"
              :input "xxx xxx"
              :output ["xxx xxx"]}
             ]]
    (c/it (:description t)
      (fn [assert-that]
        (assert-that (rendering/word-wrap (:input t))
                     (c/is (:output t)))))))
