(ns coconut.v1.documentation
  #?(:cljs (:require-macros [cljs.core.async.macros :as async]))
  (:require
    [coconut.v1.platform :as platform]
    [coconut.v1.summarizing :as summarizing]
    [coconut.v1.rendering :as rendering]
    [coconut.v1.aggregation :as aggregation]
    [clojure.core.async :as async :refer [<! >!]]
    [clojure.string :as cs]
    ))

(defn ^{:private true} with-indicies
  ([elements]
   (into (vector)
         (comp (map-indexed vector)
               (map #(update % 0 inc)))
         elements)))

(def ^{:private true :const true} checkmark \✔)
(def ^{:private true :const true} x \✘)
(def ^{:private true :const true} asterisk \*)

(defmulti report-event
  (fn [state event]
    (::summarizing/type event)))

(defmethod report-event
  ::summarizing/suite-started
  ([state event]
   #::aggregation{:events []
                  :state #::{:total-number-of-tests (::summarizing/total-number-of-tests event)
                             :pending-tests []
                             :failing-tests []
                             :level 0}}))

(defmethod report-event
  ::summarizing/context-started
  ([state event]
   #::aggregation{:events [#::rendering{:type ::rendering/line
                                        :segments [#::rendering{:text (rendering/indent (::level state))}
                                                   #::rendering{:text (rendering/render-subject (::summarizing/subject event))}]}]
                  :state (update state
                                 ::level inc)}))

(defmethod report-event
  ::summarizing/context-finished
  ([state event]
   #::aggregation{:events []
                  :state (update state
                                 ::level dec)}))

(defmethod report-event
  ::summarizing/test-pending
  ([state event]
   #::aggregation{:events [#::rendering{:type ::rendering/line
                                        :segments [#::rendering{:text (rendering/indent (::level state))}
                                                   #::rendering{:text asterisk
                                                                :color ::rendering/yellow}
                                                   #::rendering{:text (rendering/spacing 1)}
                                                   #::rendering{:text (::summarizing/description event)
                                                                :color ::rendering/yellow}]}]
                  :state (update state
                                 ::pending-tests conj event)}))

(defmethod report-event
  ::summarizing/test-passed
  ([state event]
   #::aggregation{:events [#::rendering{:type ::rendering/line
                                        :segments [#::rendering{:text (rendering/indent (::level state))}
                                                   #::rendering{:text checkmark
                                                                :color ::rendering/green}
                                                   #::rendering{:text (rendering/spacing 1)}
                                                   #::rendering{:text (::summarizing/description event)
                                                                :color ::rendering/green}]}]
                  :state state}))

(defmethod report-event
  ::summarizing/test-failed
  ([state event]
   #::aggregation{:events [#::rendering{:type ::rendering/line
                                        :segments [#::rendering{:text (rendering/indent (::level state))}
                                                   #::rendering{:text x
                                                                :color ::rendering/red}
                                                   #::rendering{:text (rendering/spacing 1)}
                                                   #::rendering{:text (::summarizing/description event)
                                                                :color ::rendering/red}]}]
                  :state (update state
                                 ::failing-tests conj event)}))

(defmethod report-event
  ::summarizing/test-threw-exception
  ([state event]
   #::aggregation{:events [#::rendering{:type ::rendering/line
                                        :segments [#::rendering{:text (rendering/indent (::level state))}
                                                   #::rendering{:text x
                                                                :color ::rendering/red}
                                                   #::rendering{:text (rendering/spacing 1)}
                                                   #::rendering{:text (::summarizing/description event)
                                                                :color ::rendering/red}]}]
                  :state (update state
                                 ::failing-tests conj event)}))

(defmethod report-event
  ::summarizing/test-timed-out
  ([state event]
   #::aggregation{:events [#::rendering{:type ::rendering/line
                                        :segments [#::rendering{:text (rendering/indent (::level state))}
                                                   #::rendering{:text x
                                                                :color ::rendering/red}
                                                   #::rendering{:text (rendering/spacing 1)}
                                                   #::rendering{:text (::summarizing/description event)
                                                                :color ::rendering/red}]}]
                  :state (update state
                                 ::failing-tests conj event)}))

(defmethod report-event
  ::summarizing/suite-finished
  ([state event]
   #::aggregation{:events []
                  :state state}))

(defmethod report-event
  :default
  ([state event]
   #::aggregation{:events []
                  :state state}))
