(ns coconut.v1.main
  (:require
    [coconut.v1.platform :as platform]
    [coconut.v1.query :as query]
    [coconut.v1.running :as running]
    [coconut.v1.summarizing :as summarizing]
    [coconut.v1.documentation :as documentation]
    [coconut.v1.progress :as progress]
    [coconut.v1.results :as results]
    [coconut.v1.karma :as karma]
    [coconut.v1.html :as html]
    [coconut.v1.console :as console]
    [coconut.v1.cli :as cli]
    [coconut.v1.util :as util]
    [coconut.v1.aggregation :as aggregation]
    ))

(defn reporter
  ([sym]
   (case sym
     :documentation documentation/report-event
     :progress progress/report-event
     :results results/report-event
     (throw (platform/illegal-argument-exception
              (platform/format "unsupported reporter: %s" (pr-str sym)))))))

(defn reporters
  ([options]
   (into (vector)
         (map reporter)
         (:reporters options))))

(defn output
  ([options]
   (case (:output options)
     :cli cli/output
     :html html/output
     (throw (platform/illegal-argument-exception
              (platform/format "unsupported output: %s"
                               (:output options)))))))

(defn normalize-options
  ([options]
   (-> options
       (js->clj :keywordize-keys true)
       (update :reporters (partial map keyword))
       (update :output keyword))))

(defn ^{:export true} run
  ([options]
   (let [options (normalize-options options)
         reporter (->> (reporters options)
                       (aggregation/compose)
                       (aggregation/aggregation))
         output (output options)]
     (-> (:criteria options)
         (query/query)
         (running/run)
         (summarizing/summarize)
         (reporter)
         (output)))))
