(ns coconut.v1.main
  (:require
    [clojure.core.async :as async]
    [coconut.v1.platform :as platform]
    [coconut.v1.query :as query]
    [coconut.v1.running :as running]
    [coconut.v1.summarizing :as summarizing]
    [coconut.v1.progress :as progress]
    [coconut.v1.documentation :as documentation]
    [coconut.v1.results :as results]
    [coconut.v1.cli :as cli]
    [coconut.v1.aggregation :as aggregation]
    ))

(defn reporters
  ([options]
   (into (vector)
         (map (fn [s]
                (case s
                  :documentation documentation/report-event
                  :progress progress/report-event
                  :results results/report-event
                  (throw (platform/illegal-argument-exception
                           (platform/format "unsupported reporter: %s" s))))))
         (:reporters options))))

(defn run
  ([options]
   (let [reporter (->> (reporters options)
                       (aggregation/compose)
                       (aggregation/aggregation))]
     (-> (:critera options query/all)
         (query/query)
         (running/run)
         (summarizing/summarize)
         (reporter)
         (cli/output)
         (async/<!!)))))
