(ns coconut.v1.rendering-test
  (:require
    [coconut.v1.core :as c]
    [coconut.v1.rendering :as rendering]
    ))

; ;; is this a good idea?
; (c/describe-function #'rendering/word-wrap
;   (fn [=>]
;     (=> [0]  [0])
;     (=> [1]  [1])
;     (=> [2]  [2])
;     (=> [3]  [3])
;     (=> [4]  [2 2])
;     (=> [5]  [5])
;     (=> [6]  [2 3])
;     (=> [7]  [7])
;     (=> [8]  [2 2 2])
;     (=> [9]  [9])
;     (=> [10] [2 5])
;     (=> [11] [11])
;     (=> [12] [2 3 3])
;     (=> [13] [13])
;     (=> [14] [2 7])
;     (=> [15] [3 5])))

(c/describe `rendering/word-wrap
  (c/for [t [{:description "returns empty collection for empty string"
              :input ""
              :output []}
             {:description "returns a single line for a single word less than the limit"
              :input "xxx"
              :output ["xxx"]}
             {:description "returns a single line for a single world which is longer than the limit"
              :input "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"
              :output ["xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"]}
             {:description "returns a single line for multiple words which are less than the limit"
              :input "xxx xxx"
              :output ["xxx xxx"]}
             ]]
    (c/it (:description t)
      (fn [assert-that]
        (assert-that (rendering/word-wrap (:input t))
                     (c/is (:output t)))))))
