(ns coconut.v1.main
  (:require
    [coconut.v1.platform :as platform]
    [coconut.v1.query :as query]
    [coconut.v1.running :as running]
    [coconut.v1.summarizing :as summarizing]
    [coconut.v1.documentation :as documentation]
    [coconut.v1.progress :as progress]
    [coconut.v1.results :as results]
    [coconut.v1.karma :as karma]
    [coconut.v1.html :as html]
    [coconut.v1.console :as console]
    [coconut.v1.cli :as cli]
    [coconut.v1.util :as util]
    ))

(defn reporters
  ([options]
   (into (vector)
         (map (fn [s]
                (case s
                  :documentation documentation/report
                  :progress progress/report
                  :results results/report
                  (throw (platform/illegal-argument-exception
                           (platform/format "unsupported reporter: %s" s))))))
         (:reporters options))))

(defn output
  ([channel options]
   ((case (:output options)
      :cli cli/output
      :html html/output
      (throw (platform/illegal-argument-exception
               (platform/format "unsupported output: %s"
                                (:output options)))))
    channel)))

(defn ^{:export true} run
  ([options]
   (let [options (-> options
                     (js->clj :keywordize-keys true)
                     (update :reporters (partial map keyword))
                     (update :output keyword))]
     (-> (:criteria options)
         (query/query)
         (running/run)
         (summarizing/summarize)
         (util/run-consumers (reporters options))
         (output options)))))
