(ns coconut.v1.cli
  #?(:cljs (:require-macros [cljs.core.async.macros :as async]))
  (:require
    [clojure.core.async :as async :refer [<!]]
    [coconut.v1.rendering :as rendering]
    [coconut.v1.platform :as platform]
    [coconut.v1.util :as util]
    ))

(defn ^{:private true} ansi
  ([color-code]
   (fn [& strings]
     (apply str
            (into (vector)
                  (map (partial platform/format
                                "\u001b[%sm%s\u001b[0m"
                                color-code))
                  strings)))))

(def ^{:private true} bold
  (ansi 1))

(def ^{:private true} grey
  (ansi 30))

(def ^{:private true} red
  (ansi 31))

(def ^{:private true} green
  (ansi 32))

(def ^{:private true} yellow
  (ansi 33))

(def ^{:private true} blue
  (ansi 34))

(def ^{:private true} teal
  (ansi 36))

(defn ^{:private true} render-colorized-output
  ([data]
   (let [f (case (::rendering/color data)
             ::rendering/grey grey
             ::rendering/red red
             ::rendering/green green
             ::rendering/yellow yellow
             ::rendering/teal teal
             nil str
             (throw (platform/illegal-argument-exception
                      (str "unsupported color: "
                           (::rendering/color data)))))]
     (bold (f (::rendering/text data))))))

(defmulti ^{:private true} print-output
  (fn [data]
    (::rendering/type data)))

(defmethod ^{:private true} print-output
  ::rendering/newline
  ([data]
   (println)))

(defmethod ^{:private true} print-output
  ::rendering/line
  ([data]
   (println (transduce (map render-colorized-output)
                       str
                       (::rendering/segments data)))))

(defmethod ^{:private true} print-output
  ::rendering/segment
  ([data]
   (do (print (transduce (map render-colorized-output)
                         str
                         (::rendering/segments data)))
       (flush))))

(def output
  "Given a core.async channel of output, prints it to
  the console. Returns nil."
  (util/channel-consuming print-output))
