(ns coconut.v1.util
  #?(:cljs (:require-macros [cljs.core.async.macros :as async]))
  (:require
    [clojure.core.async :as async :refer [<! >!]]
    ))

(defn channel-consuming
  "Given a function, returns a new function which is invoked for
  each value taken from the channel."
  ([f]
   (fn [channel]
     (async/go
       (loop []
         (when-let [e (<! channel)]
           (f e)
           (recur)))))))

(defn run-consumers
  ([channel fs]
   (let [output-channel (async/chan)
         input-channels (into (vector)
                              (take (count fs))
                              (repeatedly async/chan))
         executions (into (vector)
                          (map-indexed (fn [idx f]
                                         (f (input-channels idx) output-channel)))
                          fs)]
     (do (async/go
           (loop []
             (if-let [e (<! channel)]
               (do (doseq [c input-channels]
                     (>! c e))
                   (recur))
               (doseq [c input-channels]
                 (async/close! c)))))
         (async/go
           (doseq [c executions]
             (<! c))
           (async/close! output-channel))
         output-channel))))
