(ns coconut.v1.hamcrest-test
  (:require
    [coconut.v1.core :as c]
    [coconut.v1.matchers :as m]
    [coconut.v1.hamcrest :as h]
    ))

(defn passes-for
  [actual]
  (fn [matcher]
    (when-let [error (m/evaluate-matcher matcher actual)]
      {:expected "the given matcher to return no error"
       :actual (pr-str error)})))

(defn fails-for
  [actual]
  (fn [matcher]
    (when-not (m/evaluate-matcher matcher actual)
      {:expected "the given matcher to return an error"
       :actual "no error"})))
