package coconut;

import java.util.Collection;

public final class StubbedThrowable extends Throwable {
  private Collection<StackTraceElement> stackTraceElements;

  public StubbedThrowable(String message, Collection<StackTraceElement> stackTraceElements) {
    super(message);
    this.stackTraceElements = stackTraceElements;
  }

  @Override
  public StackTraceElement[] getStackTrace() {
    StackTraceElement[] stackTraceElements = new StackTraceElement[this.stackTraceElements.size()];
    return this.stackTraceElements.toArray(stackTraceElements);
  }
}
