(ns coconut.v1.hamcrest
  (:refer-clojure :exclude [and or])
  (:require
    [coconut.v1.matchers :as matchers]
    ))

(extend-protocol matchers/IMatcher
  org.hamcrest.Matcher
  (evaluate-matcher [matcher actual]
    (when-not (.matches matcher actual)
      {:expected (let [description (org.hamcrest.StringDescription.)]
                   (do (.describeTo matcher description)
                       (.toString description)))
       :actual (let [description (org.hamcrest.StringDescription.)]
                 (do (.describeMismatch matcher actual description)
                     (.toString description)))})))

(defmacro all-of
  ([& arguments]
   `(org.hamcrest.core.AllOf/allOf ~@arguments)))

(defmacro any-of
  ([& arguments]
   `(org.hamcrest.core.AnyOf/anyOf ~@arguments)))

; (defmacro and
;   ([& arguments]
;    `(org.hamcrest.core.CombinableMatcher/and ~@arguments)))

(defmacro anything
  ([& arguments]
   `(org.hamcrest.CoreMatchers/IsAnything/anything ~@arguments)))

; (defmacro both
;   ([& arguments]
;    `(org.hamcrest.core.CombinableMatcher/both ~@arguments)))

; (defmacro either
;   ([& arguments]
;    `(org.hamcrest.core.CombinableMatcher/either ~@arguments)))

(defmacro every-item
  ([& arguments]
   `(org.hamcrest.core.Every/everyItem ~@arguments)))

(defmacro has-item
  ([& arguments]
   `(org.hamcrest.core.IsCollectionContaining/hasItem ~@arguments)))

(defmacro has-items
  ([& arguments]
   `(org.hamcrest.core.IsCollectionContaining/hasItems ~@arguments)))

(defmacro is
  ([& arguments]
   `(org.hamcrest.CoreMatchers/is ~@arguments)))

(defmacro or
  ([& arguments]
   `(org.hamcrest.CombinableMatcher/or ~@arguments)))

(defmacro not-null-value
  ([& arguments]
   `(org.hamcrest.CoreMatchers/notNullValue ~@arguments)))

(defmacro ends-with
  ([& arguments]
   `(org.hamcrest.CoreMatchers/endsWith ~@arguments)))
