(ns coconut.repl
  (:require
    [clojure.tools.namespace.repl :as ctnr]
    [clojure.repl :refer :all]
    [clojure.string :as cs]
    [coconut.v1.main :as m]
    [coconut.v1.platform :as platform]
    ))

(defn generate-uuid
  ([]
   (platform/generate-uuid)))

(defn run-tests*
  ([]
   (m/run {:reporter :documentation
           :critera [:and
                     [:namespace-matches #"coconut.*-test"]
                     [:not [:has-tag :fixture]]]})))

(defn run-tests
  ([]
   (ctnr/refresh :after `run-tests*)))
