(ns coconut.v1.test-helpers
  #?(:clj (:import [coconut StubbedThrowable]))
  #?(:cljs (:require-macros [cljs.core.async.macros :as async]
                            [coconut.v1.test-helpers]))
  (:require
    [clojure.core.async :as async :refer [<!]]
    [coconut.v1.platform :as platform]
    [coconut.v1.core :as core]
    [coconut.v1.query :as q]
    [coconut.v1.test-namespaces.fixtures]
    ))

(defn go->promise-channel
  ([c]
   (let [pc (async/promise-chan)]
     (async/go
       (async/>! pc
                 (async/<! c)))
     pc)))

(defn number-of-events-function
  ([event-key]
   (fn [events event-type]
     (count (into (vector)
                  (filter (comp (partial = event-type)
                                event-key))
                  events)))))

(defn load-fixtures
  ([]
   (-> (q/within-namespace 'coconut.v1.test-namespaces.fixtures)
       (q/and (q/has-tag :fixture))
       (q/query)
       (::core/sub-components)
       (::core/components))))

(defn find-component-with-unique-tag
  ([namespace-name tag]
   (let [collection-component (q/query (q/and (q/within-namespace namespace-name)
                                              (q/has-tag tag)))]
     (if (zero? (::q/total-number-of-tests collection-component))
       (throw (platform/illegal-argument-exception
                (platform/format "component with tag of %s not found"
                                 (pr-str tag))))
       (first (::core/components (::core/sub-components collection-component)))))))

(defn one-second-increment-time-provider
  ([]
   (let [state (atom 0)]
     (fn []
       (let [n @state]
         (do (swap! state (partial + 1000)) n))))))

#?(:clj
   (defn create-stubbed-throwable
     ([& {:keys [message stack-trace]}]
      (let [stack-trace-elements (into (vector)
                                       (map (fn [el]
                                              (StackTraceElement. (:declaring-class el)
                                                                  (:method-name el)
                                                                  (:file-name el)
                                                                  (:line-number el))))
                                       stack-trace)]
        (StubbedThrowable. message stack-trace-elements)))))

#?(:cljs
   (defn create-stubbed-throwable
     ([& {:keys [message stack-trace]}]
      (let [e (js/Error. message)]
        (set! (.-stack e)
              (apply str
                     (interpose \newline
                                (into (vector)
                                      (map (fn [el]
                                             (platform/format "%s.%s(%s:%s)"
                                                              (:declaring-class el)
                                                              (:method-name el)
                                                              (:file-name el)
                                                              (:line-number el))))
                                      stack-trace))))
        e))))
