(ns coconut.v1.main
  (:require
    [coconut.v1.platform :as platform]
    [coconut.v1.query :as query]
    [coconut.v1.running :as running]
    [coconut.v1.summarizing :as summarizing]
    [coconut.v1.documentation :as documentation]
    ; [coconut.v1.karma :as karma]
    ; [coconut.v1.html :as html]
    [coconut.v1.console :as console]
    [coconut.v1.cli :as cli]
    ))

(defmulti ^{:private true} run*
  (fn [options]
   {(:reporter options) (:output options)}))

(defmethod ^{:private true} run*
  {:documentation :cli}
  ([options]
   (-> (:criteria options)
       (query/query)
       (running/run)
       (summarizing/summarize)
       (documentation/report)
       (cli/output))))

(defmethod ^{:private true} run*
  {:documentation :console}
  ([options]
   (-> (:criteria options)
       (query/query)
       (running/run)
       (summarizing/summarize)
       (documentation/report)
       (console/output))))

; (defmethod ^{:private true} run*
;   {:documentation :html}
;   ([options]
;    (-> (:criteria options)
;        (query/query)
;        (running/run)
;        (summarizing/summarize)
;        (documentation/report)
;        (html/output))))

; (defmethod ^{:private true} run*
;   {nil :karma}
;   ([options]
;    (karma/set-karma-start-function!
;      (fn []
;        (-> (:criteria options)
;            (query/query)
;            (running/run)
;            (summarizing/summarize)
;            (karma/report))))))

(defmethod ^{:private true} run*
  :default
  ([options]
   (throw (platform/illegal-argument-exception
            (str "unsupported combination of reporter and output: "
                 (pr-str [(:reporter options)
                          (:output options)]))))))

(defn ^{:export true} run
  ([options]
   (-> options
       (js->clj :keywordize-keys true)
       (update :reporter keyword)
       (update :output keyword)
       (run*))))
