(ns coconut.v1.main
  (:require
    [clojure.core.async :as async]
    [coconut.v1.platform :as platform]
    [coconut.v1.query :as query]
    [coconut.v1.running :as running]
    [coconut.v1.summarizing :as summarizing]
    [coconut.v1.documentation :as documentation]
    [coconut.v1.cli :as cli]
    ))

(defmulti run
  (fn [options]
    (:reporter options)))

(defmethod run
  :documentation
  ([options]
   (-> (:critera options query/all)
       (query/query)
       (running/run)
       (summarizing/summarize)
       (documentation/report)
       (cli/output)
       (async/<!!))))

(defmethod run
  :default
  ([options]
   (throw (platform/illegal-argument-exception
            (str "unsupported reporter: " (::reporter options))))))
