(ns coconut.repl
  (:require
    [clojure.tools.namespace.repl :as ctnr]
    [clojure.repl :refer :all]
    [clojure.string :as cs]
    [coconut.v1.main :as m]
    [coconut.v1.query :as q]
    [coconut.v1.platform :as platform]
    ))

(defn generate-uuid
  ([]
   (platform/generate-uuid)))

(defn run-tests*
  ([]
   (m/run {:critera (q/and (q/namespace-matches #"coconut.*-test")
                           (q/not (q/has-tag :fixture)))
           :reporter :documentation})))

(defn run-tests
  ([]
   (ctnr/refresh :after `run-tests*)))
