/*
 * Decompiled with CFR 0.152.
 */
package com.aaizuss.http;

import com.aaizuss.http.Response;
import java.util.Hashtable;
import java.util.Map;

public class ResponseSerializer {
    private static final String CRLF = "\r\n";
    private Response response;

    public ResponseSerializer(Response response) {
        this.response = response;
    }

    public byte[] getResponseBytes() {
        String header = this.statusLineAndHeaders();
        byte[] headerBytes = header.getBytes();
        byte[] body = this.response.getBody();
        byte[] response = new byte[headerBytes.length + body.length];
        System.arraycopy(headerBytes, 0, response, 0, headerBytes.length);
        System.arraycopy(body, 0, response, headerBytes.length, body.length);
        return response;
    }

    private String formatHeaders() {
        String headerString = "";
        Hashtable<String, String> headers = this.response.getHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            headerString = headerString + name + ": " + value + CRLF;
        }
        return headerString + CRLF;
    }

    private String statusLineAndHeaders() {
        String statusLine = this.response.getStatus() + CRLF;
        String headerFields = this.formatHeaders();
        return statusLine + headerFields;
    }
}

