/*
 * Decompiled with CFR 0.152.
 */
package com.aaizuss.ResourceStore;

import com.aaizuss.ResourceStore.FileDirectoryNotFoundException;
import com.aaizuss.ResourceStore.ResourceStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;

public class FileDirectory
implements ResourceStore {
    private String pathString;
    private ArrayList<String> resources = new ArrayList();

    public FileDirectory(String absolutePath) throws FileDirectoryNotFoundException {
        this.checkDirectoryExists(absolutePath);
        this.pathString = this.formatPathString(absolutePath);
        this.resources = this.initResources(this.pathString);
    }

    public String getPathString() {
        return this.pathString;
    }

    @Override
    public boolean containsResource(String uri) {
        String path = this.getPathToResource(uri);
        File file = new File(path);
        return file.exists();
    }

    @Override
    public ArrayList<String> getResources() {
        return this.resources;
    }

    @Override
    public byte[] read(String uri) {
        String path = this.getPathToResource(uri);
        return this.readFromPath(path);
    }

    private byte[] readFromPath(String absolutePath) {
        File file = new File(absolutePath);
        byte[] content = new byte[]{};
        if (file.isFile()) {
            try {
                content = Files.readAllBytes(file.toPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    private String getPathToResource(String uri) {
        File file = this.uriToFile(uri);
        return file.getPath();
    }

    private File uriToFile(String uri) {
        String identifier = uri;
        if (!uri.startsWith("/")) {
            identifier = "/" + uri;
        }
        return new File(this.pathString + identifier);
    }

    private String formatPathString(String pathString) {
        if (pathString.endsWith("/")) {
            return pathString.substring(0, pathString.length() - 1);
        }
        return pathString;
    }

    private ArrayList<String> initResources(String pathString) {
        File file = new File(pathString);
        String[] files = file.list();
        ArrayList<String> fileList = new ArrayList<String>();
        for (String entry : files) {
            fileList.add(entry);
        }
        return fileList;
    }

    private void checkDirectoryExists(String directoryPath) throws FileDirectoryNotFoundException {
        File file = new File(directoryPath);
        if (!file.exists()) {
            throw new FileDirectoryNotFoundException(directoryPath);
        }
    }
}

