/*
 * Decompiled with CFR 0.152.
 */
package com.aaizuss.http;

import com.aaizuss.http.RangeParser;
import java.util.Hashtable;
import java.util.Objects;

public class Request {
    private Hashtable<String, String> headers;
    private String uri;
    private String httpVersion;
    private String body;
    private String method;
    private String params;
    private Hashtable<String, Integer> contentRange;

    public Request() {
        this.headers = new Hashtable();
    }

    public Request(String method, String uri) {
        this.method = method;
        this.uri = uri;
        this.httpVersion = "HTTP/1.1";
        this.params = "";
        this.headers = new Hashtable();
    }

    public Request(String method, String uri, String httpVersion) {
        this.method = method;
        this.uri = uri;
        this.httpVersion = httpVersion;
        this.params = "";
        this.headers = new Hashtable();
    }

    public Request(String method, String uri, String params, String httpVersion) {
        this.method = method;
        this.uri = uri;
        this.httpVersion = httpVersion;
        this.params = params;
        this.headers = new Hashtable();
    }

    public String getMethod() {
        return this.method;
    }

    public String getBody() {
        if (this.body == null) {
            return "";
        }
        return this.body;
    }

    public String getUri() {
        return this.uri;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public String getParams() {
        return this.params;
    }

    public String getHeader(String fieldName) {
        return this.getHeaders().get(fieldName);
    }

    public Hashtable<String, Integer> getContentRange() {
        String header = this.getHeader("Range");
        this.contentRange = new Hashtable();
        if (header != null) {
            String[] rangeValues = RangeParser.getRangeValues(header);
            this.setContentRange(rangeValues);
        }
        return this.contentRange;
    }

    public boolean isPartial() {
        return !this.getContentRange().isEmpty();
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setUri(String requestTarget) {
        this.uri = requestTarget;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void addHeader(String fieldName, String fieldValue) {
        this.headers.put(fieldName, fieldValue);
    }

    public Hashtable<String, String> getHeaders() {
        return this.headers;
    }

    private void setContentRange(String[] rangeValues) {
        String start = rangeValues[0];
        String end = rangeValues[1];
        if (start.length() > 0) {
            this.contentRange.put("Start", Integer.parseInt(start));
        }
        if (end.length() > 0) {
            this.contentRange.put("End", Integer.parseInt(end));
        }
    }

    public String toString() {
        String requestLine = this.getMethod() + " " + this.getUri() + " " + this.getHttpVersion();
        if (this.getParams().length() > 0) {
            requestLine = requestLine + "\nParams: " + this.getParams();
        }
        return requestLine;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request request = (Request)o;
        return Objects.equals(this.method, request.getMethod()) && Objects.equals(this.uri, request.getUri()) && Objects.equals(this.httpVersion, request.getHttpVersion());
    }

    public int hashCode() {
        return Objects.hash(this.method, this.uri, this.httpVersion);
    }
}

