/*
 * Decompiled with CFR 0.152.
 */
package com.aaizuss.handler;

import java.util.Hashtable;

public class FileTypeReader {
    private static final Hashtable<String, String> typesMap = FileTypeReader.createTypesMap();

    public static FileType fileType(String filename) {
        String type = FileTypeReader.getContentType(filename);
        if (type.contains("text")) {
            return FileType.TEXT;
        }
        if (type.contains("image")) {
            return FileType.IMAGE;
        }
        return FileType.UNSUPPORTED;
    }

    public static String getContentType(String filename) {
        String extension = FileTypeReader.getExtension(filename);
        return typesMap.getOrDefault(extension, "application/octet-stream");
    }

    private static Hashtable<String, String> createTypesMap() {
        Hashtable<String, String> typesMap = new Hashtable<String, String>();
        typesMap.put("txt", "text/plain");
        typesMap.put("js", "text/javascript");
        typesMap.put("css", "text/css");
        typesMap.put("html", "text/html");
        typesMap.put("png", "image/png");
        typesMap.put("jpeg", "image/jpeg");
        typesMap.put("jpg", "image/jpeg");
        typesMap.put("gif", "image/gif");
        typesMap.put("md", "text/markdown");
        return typesMap;
    }

    private static String getExtension(String filename) {
        int startIndex = filename.indexOf(".") + 1;
        int endIndex = filename.length();
        return filename.substring(startIndex, endIndex);
    }

    public static enum FileType {
        IMAGE,
        TEXT,
        UNSUPPORTED;

    }
}

