/*
 * Decompiled with CFR 0.152.
 */
package com.aaizuss;

import com.aaizuss.ClientWorker;
import com.aaizuss.Router;
import com.aaizuss.io.socket.ServerSocketService;
import com.aaizuss.io.socket.ServerSocketWrapper;
import com.aaizuss.io.socket.SocketService;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Server {
    private ServerSocketService listener;
    private Router router;

    public Server(Router router) {
        this.router = router;
    }

    public void run(int port) throws IOException {
        ServerSocketService listener = this.setupListener(port);
        try {
            while (true) {
                SocketService clientSocket = listener.accept();
                ClientWorker clientWorker = new ClientWorker(clientSocket, this.router);
                ExecutorService pool = Executors.newFixedThreadPool(5);
                pool.execute(clientWorker);
            }
        }
        catch (Throwable throwable) {
            listener.close();
            throw throwable;
        }
    }

    private ServerSocketService setupListener(int port) throws IOException {
        try {
            this.listener = new ServerSocketWrapper(new ServerSocket(port));
            return this.listener;
        }
        catch (BindException e) {
            e.printStackTrace();
            System.out.println("returning null from setup listener!!! (this shouldn't happen)!");
            return null;
        }
    }
}

