/*
 * Decompiled with CFR 0.152.
 */
package com.aaizuss;

import com.aaizuss.handler.Handler;
import com.aaizuss.handler.MissingRouteHandler;
import com.aaizuss.http.Request;
import com.aaizuss.http.Response;
import java.util.Hashtable;

public class Router {
    private Hashtable<String, Handler> routes = new Hashtable();

    public Response getResponse(Request request) {
        Handler handler = this.getHandler(request);
        if (handler == null) {
            handler = new MissingRouteHandler();
        }
        return handler.execute(request);
    }

    public String createKey(String method, String uri) {
        return method + " " + uri;
    }

    public String createKey(Request request) {
        String uri = request.getUri();
        String method = request.getMethod();
        return this.createKey(method, uri);
    }

    public void addRoute(String method, String uri, Handler handler) {
        String key = this.createKey(method, uri);
        this.routes.put(key, handler);
    }

    public Hashtable<String, Handler> getRoutes() {
        return this.routes;
    }

    private Handler getHandler(Request request) {
        String key = this.createKey(request);
        return this.routes.get(key);
    }
}

