/*
 * Decompiled with CFR 0.152.
 */
package com.aaizuss.http;

import com.aaizuss.http.AuthFormatException;
import java.util.Base64;

public class BasicAuthenticator {
    private static String BASIC = "Basic";

    public static String decodeCredentials(String codedCredentials) {
        byte[] decodedText = Base64.getDecoder().decode(codedCredentials.getBytes());
        return new String(decodedText);
    }

    public static String extractCredentials(String headerValue) throws AuthFormatException {
        if (!BasicAuthenticator.validAuthHeader(headerValue)) {
            throw new AuthFormatException();
        }
        String credentials = headerValue.substring(6);
        return credentials;
    }

    private static boolean validAuthHeader(String headerValue) {
        return BasicAuthenticator.isBasicAuthType(headerValue) && BasicAuthenticator.validLength(headerValue);
    }

    private static boolean isBasicAuthType(String headerValue) {
        return BasicAuthenticator.getAuthType(headerValue).equals(BASIC);
    }

    private static boolean validLength(String headerValue) {
        return headerValue.length() == 26;
    }

    private static String getAuthType(String headerValue) {
        String[] parts = headerValue.split(" ");
        return parts[0];
    }
}

