/*
 * Decompiled with CFR 0.152.
 */
package com.aaizuss;

import com.aaizuss.Router;
import com.aaizuss.http.MalformedRequestException;
import com.aaizuss.http.Request;
import com.aaizuss.http.RequestParser;
import com.aaizuss.http.Response;
import com.aaizuss.http.ResponseSerializer;
import com.aaizuss.io.Reader;
import com.aaizuss.io.Writer;
import com.aaizuss.io.socket.SocketService;
import java.io.IOException;

public class ClientWorker
implements Runnable {
    private SocketService socket;
    private Reader reader;
    private Writer writer;
    private Router router;

    public ClientWorker(SocketService clientSocket, Router router) {
        this.socket = clientSocket;
        this.writer = clientSocket.getResponseWriter();
        this.reader = clientSocket.getRequestReader();
        this.router = router;
    }

    @Override
    public void run() {
        try {
            Request request = this.buildRequestFromInput();
            this.respondToRequest(request);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MalformedRequestException e) {
            this.respondToMalformedRequest();
        }
        finally {
            this.writer.close();
            this.reader.close();
            this.closeSocket();
        }
    }

    private void respondToRequest(Request request) {
        Response response = this.router.getResponse(request);
        ResponseSerializer serializer = new ResponseSerializer(response);
        this.writer.write(serializer.getResponseBytes());
    }

    private void respondToMalformedRequest() {
        Response response = new Response("HTTP/1.1 400 Bad Request");
        ResponseSerializer serializer = new ResponseSerializer(response);
        this.writer.write(serializer.getResponseBytes());
    }

    private Request buildRequestFromInput() throws IOException, MalformedRequestException {
        RequestParser parser = new RequestParser();
        return parser.parseRequest(this.reader);
    }

    private void closeSocket() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            System.err.println("Unable to close client socket");
            e.printStackTrace();
        }
    }
}

